(function ($) {
    "use strict";
	
	var $window = $(window); 
	var $body = $('body'); 

	/* Preloader Effect */
	$window.on('load', function(){
		$(".preloader").fadeOut(600);
	});

	/* Sticky Header */	
	if($('.active-sticky-header').length){
		$window.on('resize', function(){
			setHeaderHeight();
		});

		function setHeaderHeight(){
	 		$("header.main-header").css("height", $('header .header-sticky').outerHeight());
		}	
	
		$window.on("scroll", function() {
			var fromTop = $(window).scrollTop();
			setHeaderHeight();
			var headerHeight = $('header .header-sticky').outerHeight()
			$("header .header-sticky").toggleClass("hide", (fromTop > headerHeight + 100));
			$("header .header-sticky").toggleClass("active", (fromTop > 600));
		});
	}	
	
	/* Slick Menu JS */
	$('#menu').slicknav({
		label : '',
		prependTo : '.responsive-menu'
	});

	if($("a[href='#top']").length){
		$(document).on("click", "a[href='#top']", function() {
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});
	}

	/* Hero Slider Layout JS */
	const hero_slider_layout = new Swiper('.hero-slider-layout .swiper', {
		slidesPerView : 1,
		speed: 1000,
		spaceBetween: 0,
		loop: true,
		autoplay: {
			delay: 4000,
		},
		pagination: {
			el: '.hero-pagination',
			clickable: true,
		},
	});

	/* Testimonial Guarantee Logo Slider JS */
	if ($('.donar-company-slider').length) {
		const donar_company_slider = new Swiper('.donar-company-slider .swiper', {
			slidesPerView : 2,
			speed: 2000,
			spaceBetween: 50,
			loop: true,
			autoplay: {
				delay: 5000,
			},
			breakpoints: {
				768:{
				  	slidesPerView: 3,
				},
				991:{
				  	slidesPerView: 3,
				}
			}
		});
	}

	/* testimonial Slider JS */
	if ($('.testimonial-slider').length) {
		const testimonial_slider = new Swiper('.testimonial-slider .swiper', {
			slidesPerView : 1,
			speed: 1000,
			spaceBetween: 30,
			loop: true,
			autoplay: {
				delay: 5000,
			},
			pagination: {
				el: '.testimonial-pagination',
				clickable: true,
			},
			navigation: {
				nextEl: '.testimonial-button-next',
				prevEl: '.testimonial-button-prev',
			},
			breakpoints: {
				768:{
					slidesPerView: 1,
				},
				991:{
					slidesPerView: 1,
				}
			}
		});
	}

	/* Skill Bar */
	if ($('.skills-progress-bar').length) {
		$('.skills-progress-bar').waypoint(function() {
			$('.skillbar').each(function() {
				$(this).find('.count-bar').animate({
				width:$(this).attr('data-percent')
				},2000);
			});
		},{
			offset: '50%'
		});
	}

	/* Youtube Background Video JS */
	if ($('#herovideo').length) {
		var myPlayer = $("#herovideo").YTPlayer();
	}

	/* Init Counter */
	if ($('.counter').length) {
		$('.counter').counterUp({ delay: 6, time: 3000 });
	}

	/* Image Reveal Animation */
	if ($('.reveal').length) {
        gsap.registerPlugin(ScrollTrigger);
        let revealContainers = document.querySelectorAll(".reveal");
        revealContainers.forEach((container) => {
            let image = container.querySelector("img");
            let tl = gsap.timeline({
                scrollTrigger: {
                    trigger: container,
                    toggleActions: "play none none none"
                }
            });
            tl.set(container, {
                autoAlpha: 1
            });
            tl.from(container, 1, {
                xPercent: -100,
                ease: Power2.out
            });
            tl.from(image, 1, {
                xPercent: 100,
                scale: 1,
                delay: -1,
                ease: Power2.out
            });
        });
    }

	/* Text Effect Animation */
	if ($('.text-anime-style-1').length) {
		let staggerAmount 	= 0.05,
			translateXValue = 0,
			delayValue 		= 0.5,
		   animatedTextElements = document.querySelectorAll('.text-anime-style-1');
		
		animatedTextElements.forEach((element) => {
			let animationSplitText = new SplitText(element, { type: "chars, words" });
				gsap.from(animationSplitText.words, {
				duration: 1,
				delay: delayValue,
				x: 20,
				autoAlpha: 0,
				stagger: staggerAmount,
				scrollTrigger: { trigger: element, start: "top 85%" },
				});
		});		
	}
	
	if ($('.text-anime-style-2').length) {				
		let	 staggerAmount 		= 0.03,
			 translateXValue	= 20,
			 delayValue 		= 0.1,
			 easeType 			= "power2.out",
			 animatedTextElements = document.querySelectorAll('.text-anime-style-2');
		
		animatedTextElements.forEach((element) => {
			let animationSplitText = new SplitText(element, { type: "chars, words" });
				gsap.from(animationSplitText.chars, {
					duration: 1,
					delay: delayValue,
					x: translateXValue,
					autoAlpha: 0,
					stagger: staggerAmount,
					ease: easeType,
					scrollTrigger: { trigger: element, start: "top 85%"},
				});
		});		
	}
	
	if ($('.text-anime-style-3').length) {		
		let	animatedTextElements = document.querySelectorAll('.text-anime-style-3');
		
		 animatedTextElements.forEach((element) => {
			//Reset if needed
			if (element.animation) {
				element.animation.progress(1).kill();
				element.split.revert();
			}

			element.split = new SplitText(element, {
				type: "lines,words,chars",
				linesClass: "split-line",
			});
			gsap.set(element, { perspective: 400 });

			gsap.set(element.split.chars, {
				opacity: 0,
				x: "50",
			});

			element.animation = gsap.to(element.split.chars, {
				scrollTrigger: { trigger: element,	start: "top 90%" },
				x: "0",
				y: "0",
				rotateX: "0",
				opacity: 1,
				duration: 1,
				ease: Back.easeOut,
				stagger: 0.02,
			});
		});		
	}

	/* Parallaxie js */
	/* var $parallaxie = $('.parallaxie');
	if($parallaxie.length && ($window.width() > 991))
	{
		if ($window.width() > 768) {
			$parallaxie.parallaxie({
				speed: 0.55,
				offset: 0,
			});
		}
	} */

	/* Zoom Gallery screenshot */
	$('.gallery-items').magnificPopup({
		delegate: 'a',
		type: 'image',
		closeOnContentClick: false,
		closeBtnInside: false,
		mainClass: 'mfp-with-zoom',
		image: {
			verticalFit: true,
		},
		gallery: {
			enabled: true
		},
		zoom: {
			enabled: true,
			duration: 300, // don't foget to change the duration also in CSS
			opener: function(element) {
			  return element.find('img');
			}
		}
	});

	/* Contact form validation */
	var $contactform = $("#contactForm");
	$contactform.validator({focus: false}).on("submit", function (event) {
		if (!event.isDefaultPrevented()) {
			event.preventDefault();
			submitForm();
		}
	});

	function submitForm(){
		/* Ajax call to submit form */
		$.ajax({
			type: "POST",
			url: "form-process.php",
			data: $contactform.serialize(),
			success : function(text){
				if (text === "success"){
					formSuccess();
				} else {
					submitMSG(false,text);
				}
			}
		});
	}

	function formSuccess(){
		$contactform[0].reset();
		submitMSG(true, "Message Sent Successfully!")
	}

	function submitMSG(valid, msg){
		if(valid){
			var msgClasses = "h4 text-success";
		} else {
			var msgClasses = "h4 text-danger";
		}
		$("#msgSubmit").removeClass().addClass(msgClasses).text(msg);
	}
	/* Contact form validation end */

	/* Animated Wow Js */	
	new WOW().init();

	/* Popup Video */
	if ($('.popup-video').length) {
		$('.popup-video').magnificPopup({
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: true
		});
	}

	/* Our Gallery (filtering) Start */
	$window.on( "load", function(){
		if( $(".gallery-item-boxes").length ) {
				
			/* Init Isotope */
			var $menuitem = $(".gallery-item-boxes").isotope({
				itemSelector: ".gallery-item-box",
				layoutMode: "masonry",
				masonry: {
					// use outer width of grid-sizer for columnWidth
					columnWidth: 1,
				}
			});
				
			/* Filter items on click */
			var $menudisesnav = $(".our-gallery-nav li a");
				$menudisesnav.on('click', function (e) { 
			
				var filterValue = $(this).attr('data-filter');
				$menuitem.isotope({
					filter: filterValue
				}); 
				
				$menudisesnav.removeClass("active-btn"); 
				$(this).addClass("active-btn");
				e.preventDefault();
			});		
			$menuitem.isotope({ filter: "*" });
		}			
	});
	/* Our Gallery (filtering) End */

	/* Service Entry Step Item Active Start */
	var $service_step_list = $('.service-entry-step-list');
	if ($service_step_list.length) {
		var $service_step = $service_step_list.find('.service-entry-step-item');

		if ($service_step.length) {
			$service_step.on({
				mouseenter: function () {
					if (!$(this).hasClass('active')) {
						$service_step.removeClass('active'); 
						$(this).addClass('active'); 
					}
				},
				mouseleave: function () {
					// Optional: Add logic for mouse leave if needed
				}
			});
		}
	}
	/*Service Entry Step Item Active End  */
	
})(jQuery);

// Program Category Navigation Script
$(document).ready(function() {
    
    // Add IDs to each program section for navigation
    addSectionIds();
    
    // Handle category link clicks
    $('.page-sidebar-catagery-list ul li a').on('click', function(e) {
        e.preventDefault();
        
        const categoryText = $(this).text().trim();
        const targetSectionId = getCategoryTargetId(categoryText);
        
        if (targetSectionId) {
            // Remove active class from all links
            $('.page-sidebar-catagery-list ul li a').removeClass('active');
            
            // Add active class to clicked link
            $(this).addClass('active');
            
            // Smooth scroll to target section
            scrollToSection(targetSectionId);
        }
    });
    
    // Function to add IDs to program sections
    function addSectionIds() {
        const sections = $('.program-single-contemt .program-entry h2');
        
        sections.each(function(index) {
            const $section = $(this).closest('.program-entry');
            const $imageSection = $section.prev('.program-feature-image');
            
            // Create a wrapper div for each program section
            const $wrapper = $('<div class="program-section"></div>');
            
            // Add appropriate ID based on content
            const headingText = $(this).text().toLowerCase();
            let sectionId;
            
            if (headingText.includes('skill development')) {
                sectionId = 'skill-development-section';
            } else if (headingText.includes('employment') || headingText.includes('placement')) {
                sectionId = 'placements-section';
            } else if (headingText.includes('accessibility')) {
                sectionId = 'accessibility-section';
            } else if (headingText.includes('financial')) {
                sectionId = 'financial-section';
            } else {
                sectionId = 'section-' + (index + 1);
            }
            
            $wrapper.attr('id', sectionId);
            
            // Wrap the image and content together
            $imageSection.before($wrapper);
            $wrapper.append($imageSection).append($section);
        });
    }
    
    // Function to map category text to section IDs
    function getCategoryTargetId(categoryText) {
        const categoryMap = {
            'Skill Development': 'skill-development-section',
            'Placements': 'placements-section',
            'Accessibility': 'accessibility-section',
            'Financial Management': 'financial-section',
            'Rights and Abilities': 'financial-section' // Assuming this maps to financial section
        };
        
        return categoryMap[categoryText] || null;
    }
    
    // Function to smoothly scroll to target section
    function scrollToSection(targetId) {
        const $target = $('#' + targetId);
        
        if ($target.length) {
            const headerHeight = $('.main-header').outerHeight() || 80;
            const targetOffset = $target.offset().top - headerHeight - 30;
            
            $('html, body').animate({
                scrollTop: targetOffset
            }, 800, 'easeInOutQuart');
            
            // Add highlight effect
            highlightSection($target);
        }
    }
    
    // Function to highlight the target section
    function highlightSection($section) {
        // Remove any existing highlights
        $('.program-section').removeClass('section-highlight');
        
        // Add highlight to target section
        $section.addClass('section-highlight');
        
        // Remove highlight after animation
        setTimeout(function() {
            $section.removeClass('section-highlight');
        }, 2000);
    }
    
    // Optional: Add scroll spy functionality to highlight active category
    function updateActiveCategory() {
        const scrollPosition = $(window).scrollTop() + 200;
        const $sections = $('.program-section');
        
        $sections.each(function() {
            const $section = $(this);
            const sectionTop = $section.offset().top;
            const sectionBottom = sectionTop + $section.outerHeight();
            
            if (scrollPosition >= sectionTop && scrollPosition < sectionBottom) {
                const sectionId = $section.attr('id');
                const categoryText = getReverseCategoryMap(sectionId);
                
                // Update active state in sidebar
                $('.page-sidebar-catagery-list ul li a').removeClass('active');
                $('.page-sidebar-catagery-list ul li a').filter(function() {
                    return $(this).text().trim() === categoryText;
                }).addClass('active');
            }
        });
    }
    
    // Function to reverse map section IDs to category text
    function getReverseCategoryMap(sectionId) {
        const reverseMap = {
            'skill-development-section': 'Skill Development',
            'placements-section': 'Placements',
            'accessibility-section': 'Accessibility',
            'financial-section': 'Financial Management'
        };
        
        return reverseMap[sectionId] || '';
    }
    
    // Throttled scroll event for scroll spy
    let scrollTimer;
    $(window).on('scroll', function() {
        clearTimeout(scrollTimer);
        scrollTimer = setTimeout(updateActiveCategory, 50);
    });
    
    // Initialize active category on page load
    setTimeout(updateActiveCategory, 500);
});

// Easing function for smooth animation
$.easing.easeInOutQuart = function (x, t, b, c, d) {
    if ((t /= d / 2) < 1) return c / 2 * t * t * t * t + b;
    return -c / 2 * ((t -= 2) * t * t * t - 2) + b;
};